using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using nsAlienRFIDcf;



namespace nsAlienMobileSDK
{
    public partial class Form2 : Form
    {
        clsReader mReader;
        bool mbDisposing = false;
        static string USERNAME = "alien";
        static string PASSWORD = "password";

        private delegate void showMsg();
        private delegate void showDisconnected();

        public Form2()
        {
            InitializeComponent();
        }

        private void Form2_Load(object sender, EventArgs e)
        {
            mReader = new clsReader(true);
            mReader.MessageReceived += new CBaseReader.MessageReceivedEventHandler(mReader_MessageReceived);
            mReader.Disconnected += new CBaseReader.DisconnectedEventHandler(mReader_Disconnected);
            ManageGUI(false);
        }

        void mReader_Disconnected(string message)
        {
            if (mbDisposing) return;

            lock (this)
            {
                showDisconnected method = delegate
                {
                    if (message != null)
                        addText(message.Replace("\0", ""));
                    ManageGUI(false);
                };
                this.BeginInvoke(method);
            }
        }

        private void Form2_Closing(object sender, CancelEventArgs e)
        {
            if (mReader != null)
                mReader.Dispose();

            mReader = null;
        }

        private void ManageGUI(bool connected)
        {
            txtIPAddress.Enabled = !connected;
            txtCommandPort.Enabled = !connected;
            txtTimeout.Enabled = !connected;
            btnConnect.Enabled = !connected;
            label1.Enabled = !connected;
            label2.Enabled = !connected;
            label3.Enabled = !connected;

            btnDisconnect.Enabled = connected;
            btnGetReaderInfo.Enabled = connected;
            textBox1.Enabled = connected;
            txtCommand.Enabled = connected;
            btnGetTags.Enabled = connected;
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                mReader.ComTimeOutInterval = int.Parse(txtTimeout.Text) * 1000;

                mReader.ConnectAndLogin(
                    txtIPAddress.Text,
                    int.Parse(txtCommandPort.Text),
                    USERNAME,
                    PASSWORD);

                bool isConnected = mReader.IsConnected;
                ManageGUI(isConnected);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                Cursor.Current = Cursors.Default;
            }
        }
        private void addText(string s)
        {
            textBox1.Text += s.Replace("\0", "");
            textBox1.Focus();
            textBox1.SelectAll();
            textBox1.ScrollToCaret();
            Cursor.Current = Cursors.Default;
        }

        void mReader_MessageReceived(string msg)
        {
            if ((mbDisposing) || (msg == null)) return;

            lock (this)
            {
                showMsg method = delegate
                {
                    addText(msg.Replace("\r", "[\\r]").Replace("\n", "[\\n]").Replace("\0", "[\\0]") + "\r\n");
                };
                this.BeginInvoke(method);
            }
        }
        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            if ((mReader != null) && (mReader.IsConnected))
            {
                mReader.Disconnect();
                addText("\r\nManually disconnected.");
            }
            else
                addText("\r\nNot connected.");

            ManageGUI(false);
        }

        private void btnGetReaderInfo_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                addText("\r\n" + mReader.Info);
            }
            catch (Exception ex)
            {
                addText("\r\n" + ex.Message);
            }
        }

        private void txtCommand_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                String command = txtCommand.Text.Trim();
                if (command.Length > 0)
                {
                    textBox1.Text = "";
                    try
                    {
                        // blocking call
                        string response = mReader.SendReceive(command, false);
                        addText(response + "\r\n");  

                        //  OR mReader.Send(command + "\r\n", true);   // asynchronous call
                    }
                    catch (Exception ex)
                    {
                        addText("\r\n" + ex.Message);
                    }
                }
            }
        }

        private void btnGetTags_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            try
            {
                addText("\r\n" + mReader.TagList);
            }
            catch (Exception ex)
            {
                addText("\r\n" + ex.Message);
            }
        }

    }
}